/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.collision;

import com.raoulvdberge.refinedstorage.render.collision.AdvancedRayTraceResult;
import com.raoulvdberge.refinedstorage.render.collision.CollisionGroup;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public final class AdvancedRayTracer {
    public static Vec3d getStart(EntityPlayer player) {
        return new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
    }

    public static Vec3d getEnd(EntityPlayer player) {
        double reachDistance = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        reachDistance = player instanceof EntityPlayerMP ? player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() : reachDistance;
        Vec3d lookVec = player.func_70040_Z();
        Vec3d start = AdvancedRayTracer.getStart(player);
        return start.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
    }

    @Nullable
    public static AdvancedRayTraceResult<RayTraceResult> rayTrace(BlockPos pos, Vec3d start, Vec3d end, Collection<CollisionGroup> groups) {
        double minDistance = Double.POSITIVE_INFINITY;
        AdvancedRayTraceResult<RayTraceResult> hit = null;
        int i = -1;
        for (CollisionGroup group : groups) {
            for (AxisAlignedBB aabb : group.getItems()) {
                double d;
                AdvancedRayTraceResult<RayTraceResult> result = AdvancedRayTracer.rayTrace(pos, start, end, aabb, i, group);
                if (result != null && (d = result.squareDistanceTo(start)) < minDistance) {
                    minDistance = d;
                    hit = result;
                }
                ++i;
            }
        }
        return hit;
    }

    public static AdvancedRayTraceResult<RayTraceResult> rayTrace(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB bounds, int subHit, CollisionGroup group) {
        RayTraceResult result = bounds.func_186670_a(pos).func_72327_a(start, end);
        if (result == null) {
            return null;
        }
        result = new RayTraceResult(RayTraceResult.Type.BLOCK, result.field_72307_f, result.field_178784_b, pos);
        result.subHit = subHit;
        return new AdvancedRayTraceResult<RayTraceResult>(group, result);
    }
}

